<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class StakingPlan extends Model
{
    protected $fillable = [
        'cryptocurrency_id',
        'name',
        'interest_rate',
        'duration',
        'minimum_amount',
        'maximum_amount',
        'status',
    ];

    public function crypto()
    {
        return $this->belongsTo(Cryptocurrency::class, 'cryptocurrency_id');
    }
}
