<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class SignalPurchase extends Model
{
    protected $fillable = ['user_id', 'signal_id', 'payment_gateway_id', 'pay_image', 'status', 'amount'];

    public function user()
    {
        return $this->belongsTo(User::class);
    }

    public function signal()
    {
        return $this->belongsTo(Signal::class);
    }

    public function gateway()
    {
        return $this->belongsTo(PaymentGateway::class, 'payment_gateway_id');
    }
}
