<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class RealEstate extends Model
{
    protected $fillable = [
        'title',
        'description',
        'short_desc',
        'price',
        'roi',
        'end_date',
        'status',
        'strategy',
        'type',
        'stories',
        'objective',
        'why_project',
        'why_sponsor',
        'site_plan',
        'organizational_chart',
        'sponsor_record',
    ];

    public function images()
    {
        return $this->hasMany(RealEstateImage::class);
    }
}
