<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class PaymentGateway extends Model
{
    use HasFactory;

    protected $fillable = [
        'name',
        'currency',
        'network',
        'wallet_address',
        'qr_code',
        'rate',
        'logo',
        'status',
        'instructions',
    ];

    public function deposits()
    {
        return $this->hasMany(Deposit::class);
    }

    /**
     * Scope to only active gateways.
     */
    public function scopeActive($query)
    {
        return $query->where('status', 'active');
    }

    /**
     * Get formatted display name (e.g. USDT - TRC20)
     */
    public function getDisplayNameAttribute()
    {
        return $this->network
            ? "{$this->currency} ({$this->network})"
            : $this->currency;
    }
}
