<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class Loan extends Model
{
    use HasFactory;

    /**
     * The attributes that are mass assignable.
     */
    protected $fillable = [
        'user_id',
        'loan_type_id',
        'amount',
        'duration',
        'interest_rate',
        'total_payable',
        'monthly_payment',
        'monthly_income',
        'reason',
        'status',
    ];

    /**
     * Relationships
     */

    // 🔗 Each loan belongs to a user
    public function user()
    {
        return $this->belongsTo(User::class);
    }

    // 🔗 Each loan belongs to a specific loan type
    public function loanType()
    {
        return $this->belongsTo(LoanType::class);
    }
}
