<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class LiveTrade extends Model
{
    protected $fillable = [
        'user_id',
        'symbol',
        'side',
        'entry_price',
        'amount',
        'asset_name',
        'market_type',
        'units',
        'leverage',
        'order_type',
        'expiration',
        'expires_at',
        'current_value',
        'profit_loss',
        'status',
        'slug',
    ];

    protected $casts = [
        'expires_at' => 'datetime',
    ];

    public function user()
    {
        return $this->belongsTo(User::class);
    }

    public function isOpen()
    {
        return $this->status === 'open';
    }
}
