<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class CopyTradeLog extends Model
{
    use HasFactory;

    protected $fillable = [
        'user_id',
        'trade_expert_id',
        'profit_amount',
        'percent_change',
        'note',
    ];

    public function user()
    {
        return $this->belongsTo(User::class);
    }

    public function expert()
    {
        return $this->belongsTo(TradeExpert::class, 'trade_expert_id');
    }
}
