<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class AiBot extends Model
{
    use HasFactory;

    protected $fillable = [
        'name',
        'success_rate',
        'trading_type',
        'daily_profit',
        'duration_days',
        'min_amount',
        'max_amount',
        'trading_frequency',
        'strategy_type',
        'trading_pairs',
        'active_users',
        'total_earned',
        'description',
        'expected_returns',
        'total_trades',
        'daily_change',
        'bots_profit',
        'status',
    ];

    protected $casts = [
        'trading_pairs' => 'array',
        'success_rate' => 'float',
        'total_earned' => 'float',
    ];

    public function userTrades()
    {
        return $this->hasMany(UserBotTrade::class);
    }
}
