<?php

namespace App\Mail;

use Illuminate\Mail\Mailable;
use Illuminate\Bus\Queueable;
use Illuminate\Queue\SerializesModels;

class TradeClosedMail extends Mailable
{
    use Queueable, SerializesModels;

    public $user;
    public $trade;
    public $reason;

    public function __construct($user, $trade, $reason)
    {
        $this->user = $user;
        $this->trade = $trade;
        $this->reason = $reason;
    }

    public function build()
    {
        return $this->subject('Trade Closed')
            ->view('emails.trade.closed');
    }
}
