<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Mail\Mailable;
use Illuminate\Mail\Mailables\Content;
use Illuminate\Mail\Mailables\Envelope;
use Illuminate\Queue\SerializesModels;

class StakingSuccessfulEmail extends Mailable
{
    use Queueable, SerializesModels;

    public $user_name;
    public $staking_amount;

    /**
     * Create a new message instance.
     *
     * @return void
     */
    public function __construct($user_name, $staking_amount)
    {
        $this->user_name = $user_name;
        $this->staking_amount = $staking_amount;
    }

    /**
     * Build the message.
     *
     * @return $this
     */
    public function build()
    {
        return $this->view('emails.staking')
            ->with([
                'user_name' => $this->user_name,
                'staking_amount' => $this->staking_amount,
                'current_year' => date('Y'),
            ]);
    }

    /**
     * Get the message envelope.
     */
    public function envelope(): Envelope
    {
        return new Envelope(
            subject: 'Staking Successful',
        );
    }

    /**
     * Get the message content definition.
     */
    public function content(): Content
    {
        return new Content(
            view: 'emails.staking',
        );
    }

    /**
     * Get the attachments for the message.
     *
     * @return array<int, \Illuminate\Mail\Mailables\Attachment>
     */
    public function attachments(): array
    {
        return [];
    }
}
