<?php

namespace App\Mail;

use Illuminate\Mail\Mailable;
use Illuminate\Bus\Queueable;
use Illuminate\Queue\SerializesModels;

class RealEstatePayoutMail extends Mailable
{
    use Queueable, SerializesModels;

    public $user;
    public $investment;

    public function __construct($user, $investment)
    {
        $this->user = $user;
        $this->investment = $investment;
    }

    public function build()
    {
        return $this->subject('Real Estate Investment Payout')
            ->view('emails.realestate.payout');
    }
}
