<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Mail\Mailable;
use Illuminate\Mail\Mailables\Content;
use Illuminate\Mail\Mailables\Envelope;
use Illuminate\Queue\SerializesModels;
use App\Models\Deposit;

class PaypalDepositApprovedMail extends Mailable
{
    use Queueable, SerializesModels;

    public $deposit;

    public function __construct(Deposit $deposit)
    {
        $this->deposit = $deposit;
    }

    public function build()
    {
        return $this->subject('Your Deposit Has Been Approved')
            ->view('emails.deposits.paypal_approved')
            ->with([
                'name'    => $this->deposit->user->firstname,
                'amount'  => number_format($this->deposit->amount, 2),
                'gateway' => 'PayPal',
                'date'    => now()->format('F j, Y, g:i A'),
            ]);
    }
}
