<?php

namespace App\Mail;

use App\Models\LiveTrade;
use App\Models\WebsiteSetting;
use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;

class LiveTradePlacedMail extends Mailable
{
    use Queueable, SerializesModels;

    public $trade;
    public $websiteSettings;

    public function __construct(LiveTrade $trade)
    {
        $this->trade = $trade;
        $this->websiteSettings = WebsiteSetting::first();
    }

    public function build()
    {
        return $this->subject('Your Live Trade Has Been Placed - ' . $this->websiteSettings->site_name)
            ->view('emails.live_trade_placed');
    }
}
