<?php

namespace App\Mail;

use App\Models\KycVerification;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;

class KycAdminAlertMail extends Mailable implements ShouldQueue
{
    use Queueable, SerializesModels;

    public $kyc;

    public function __construct(KycVerification $kyc)
    {
        $this->kyc = $kyc;
    }

    public function build()
    {
        return $this->subject('New KYC Submission - Pending Review')
            ->view('emails.kyc.admin_alert')
            ->with([
                'kyc' => $this->kyc,
                'user' => $this->kyc->user,
                'date' => $this->kyc->created_at->format('M d, Y h:i A'),
            ]);
    }
}
