<?php

namespace App\Mail;

use App\Models\Deposit;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;

class DepositPendingMail extends Mailable implements ShouldQueue
{
    use Queueable, SerializesModels;

    public $deposit;

    public function __construct(Deposit $deposit)
    {
        $this->deposit = $deposit;
    }

    public function build()
    {
        return $this->subject('Deposit Submitted Successfully - Pending Approval')
            ->view('emails.deposits.user_pending')
            ->with([
                'name' => $this->deposit->user->firstname,
                'amount' => number_format($this->deposit->amount, 2),
                'gateway' => $this->deposit->gateway->name ?? 'N/A',
                'date' => $this->deposit->created_at->format('M d, Y h:i A'),
            ]);
    }
}
