<?php

namespace App\Mail;

use App\Models\UserBotTrade;
use App\Models\WebsiteSetting;
use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;

class BotTradeStoppedMail extends Mailable
{
    use Queueable, SerializesModels;

    public $trade;
    public $user;
    public $bot;
    public $websiteSettings;

    /**
     * Create a new message instance.
     */
    public function __construct(UserBotTrade $trade)
    {
        $this->trade = $trade;
        $this->user = $trade->user;
        $this->bot = $trade->bot;
        $this->websiteSettings = WebsiteSetting::first();
    }

    /**
     * Build the message.
     */
    public function build()
    {
        return $this->subject("{$this->bot->name} Trade Stopped Successfully")
            ->view('emails.bot_trade_stopped')
            ->with([
                'name' => $this->user->firstname . ' ' . $this->user->lastname,
                'botName' => $this->bot->name,
                'amount' => number_format($this->trade->amount_invested, 2),
                'profit' => number_format($this->trade->profit_earned, 2),
                'credited' => number_format($this->trade->current_value, 2),
                'duration' => $this->bot->duration_days,
                'websiteSettings' => $this->websiteSettings,
            ]);
    }
}
