<?php

namespace App\Mail;

use App\Models\UserBotTrade;
use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;

class BotTradeStartedMail extends Mailable
{
    use Queueable, SerializesModels;

    public $trade;

    public function __construct(UserBotTrade $trade)
    {
        $this->trade = $trade;
    }

    public function build()
    {
        return $this->subject('Your AI Bot Trade Has Started')
            ->view('emails.user.bot_trade_started')
            ->with(['trade' => $this->trade]);
    }
}
