<?php

namespace App\Mail;

use App\Models\Investment;
use App\Models\WebsiteSetting;
use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;

class AdminNewInvestmentMail extends Mailable
{
    use Queueable, SerializesModels;

    public $investment;
    public $websiteSettings;

    public function __construct(Investment $investment)
    {
        $this->investment = $investment;
        $this->websiteSettings = WebsiteSetting::first();
    }

    public function build()
    {
        return $this->subject('New Investment Alert - ' . $this->websiteSettings->site_name)
            ->view('emails.admin_new_investment');
    }
}
