<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Symfony\Component\HttpFoundation\Response;

class WithdrawalAccess
{

    public function handle(Request $request, Closure $next)
    {
        $verified = session('withdrawal_verified');
        $time = session('withdrawal_verified_time');

        if (!$verified || !$time) {
            return redirect()->route('user.withdrawalaccess')
                ->with('error', 'Please confirm your password.');
        }

        // Expire after 10 minutes
        if (now()->diffInMinutes($time) > 10) {
            session()->forget(['withdrawal_verified', 'withdrawal_verified_time']);

            return redirect()->route('user.withdrawalaccess')
                ->with('error', 'Session expired. Please verify again.');
        }

        return $next($request);
    }
}
