<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Symfony\Component\HttpFoundation\Response;

class Role
{
    /**
     * Handle an incoming request.
     *
     * @param  \Closure(\Illuminate\Http\Request): (\Symfony\Component\HttpFoundation\Response)  $next
     */
    public function handle(Request $request, Closure $next, ...$roles): Response
    {
        if (!in_array($request->user()->role, $roles)) {
            $redirectPath = match ($request->user()->role) {
                'user' => '/user/dashboard',
                'admin' => '/admin/dashboard',
                default => '/user/dashboard'
            };

            return redirect($redirectPath);
        }

        return $next($request);
    }
}
