<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Support\Facades\Auth;

class Ensure2FAAuthenticated
{
    public function handle($request, Closure $next)
    {
        if (Auth::check() && Auth::user()->is_2fa_enabled) {
            if (!session('2fa_verified')) {
                return redirect()->route('2fa.setup');
            }
        }

        return $next($request);
    }
}
