<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class AccessCodeMiddleware
{
    public function handle(Request $request, Closure $next)
    {
        // 🔹 Fetch access control setting and code from website_settings
        $accessStatus = DB::table('website_settings')->value('access_code_status'); // 'Active' or 'Inactive'
        $requiredAccessCode = DB::table('website_settings')->value('access_code');   // actual access code

        // 🔹 If access control is Inactive, skip access code validation
        if (empty($accessStatus) || strtolower($accessStatus) === 'Inactive') {
            return $next($request);
        }

        // 🔹 Avoid redirect loop for the access code form route
        if ($request->routeIs('access-code.form')) {
            return $next($request);
        }

        // 🔹 Get access code from request or session
        $accessCode = $request->input('access_code')
            ?? $request->query('access_code')
            ?? $request->session()->get('access_code');

        // 🔹 If no code provided yet
        if (!$accessCode) {
            return redirect()->route('access-code.form');
        }

        // 🔹 Validate access code
        if ($accessCode !== $requiredAccessCode) {
            return redirect()->route('access-code.form')
                ->withErrors(['code' => 'Invalid access code.']);
        }

        // ✅ Store valid access code in session
        $request->session()->put('access_code', $accessCode);

        // ✅ Continue request
        return $next($request);
    }
}
