<?php

namespace App\Http\Controllers;

use App\Models\WebsiteSetting;
use Illuminate\Support\Facades\Artisan;
use Illuminate\Support\Facades\File;
use Illuminate\Support\Str;
use App\Models\Currency;
use Illuminate\Http\Request;

class WebsiteSettingController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function adminwebsitesetting(Request $request)
    {
        $pageTitle = 'Website Settings';

        $settings =  WebsiteSetting::find(1);

        $currency = Currency::where('status', '1')->get();

        return view('admin/website_settings', compact('pageTitle', 'settings', 'currency'));
    }

    /**
     * Show the form for creating a new resource.
     */
    public function websitesettingupdate(Request $request)
    {
        $save = WebsiteSetting::find(1);
        $save->site_name            = trim($request->site_name);
        $save->site_phone           = trim($request->site_phone);
        $save->site_email           = trim($request->site_email);
        $save->site_address         = trim($request->site_address);
        $save->access_code          = trim($request->access_code);
        $save->access_code_status   = trim($request->access_code_status);
        $save->whatsapp             = trim($request->whatsapp);
        $save->telegram             = trim($request->telegram);
        $save->site_description     = trim($request->site_description);
        $save->currency             = trim($request->currency);
        $save->reg_bonus            = trim($request->reg_bonus);
        $save->ref_bonus            = trim($request->ref_bonus);
        $save->require_email_verification            = trim($request->require_email_verification);

        if (!empty($request->file('site_logo'))) {

            $file = $request->file('site_logo');
            $randomStr = Str::random(10);
            $filename = $randomStr . '.' . $file->getClientOriginalExtension();
            $file->move('upload/', $filename);
            $save->site_logo = $filename;
        }

        if (!empty($request->file('site_favicon'))) {

            $file = $request->file('site_favicon');
            $randomStr = Str::random(10);
            $filename = $randomStr . '.' . $file->getClientOriginalExtension();
            $file->move('upload/', $filename);
            $save->site_favicon = $filename;
        }

        $save->save();

        return redirect()->back()->with('success', 'Website Updated successfully.');
    }

    //SMTP SETTING STARTS

    public function adminemailsettings(Request $request)
    {
        $pageTitle = 'Email SMTP Settings';

        $smtpSettings = [
            'MAIL_MAILER' => env('MAIL_MAILER'),
            'MAIL_HOST' => env('MAIL_HOST'),
            'MAIL_PORT' => env('MAIL_PORT'),
            'MAIL_USERNAME' => env('MAIL_USERNAME'),
            'MAIL_PASSWORD' => env('MAIL_PASSWORD'),
            'MAIL_ENCRYPTION' => env('MAIL_ENCRYPTION'),
            'MAIL_FROM_ADDRESS' => env('MAIL_FROM_ADDRESS'),
            'MAIL_FROM_NAME' => env('MAIL_FROM_NAME'),
        ];

        return view('admin/email_settings', compact('pageTitle', 'smtpSettings'));
    }

    public function updateSmtpSettings(Request $request)
    {
        // dd($request->all());
        $request->validate([
            'MAIL_MAILER' => 'required|string',
            'MAIL_HOST' => 'required|string',
            'MAIL_PORT' => 'required|integer',
            'MAIL_USERNAME' => 'required|string',
            'MAIL_PASSWORD' => 'required|string',
            'MAIL_ENCRYPTION' => 'nullable|string',
            'MAIL_FROM_ADDRESS' => 'required|email',
            'MAIL_FROM_NAME' => 'required|string',
        ]);

        $this->updateEnv($request->only([
            'MAIL_MAILER',
            'MAIL_HOST',
            'MAIL_PORT',
            'MAIL_USERNAME',
            'MAIL_PASSWORD',
            'MAIL_ENCRYPTION',
            'MAIL_FROM_ADDRESS',
            'MAIL_FROM_NAME'
        ]));


        return redirect()->back()->with('success', 'Email Setup updated successfully.');
    }


    private function updateEnv(array $data)
    {
        $envPath = base_path('.env');

        if (File::exists($envPath)) {
            $envContent = File::get($envPath);

            foreach ($data as $key => $value) {
                $pattern = "/^$key=.*/m";
                $replacement = "$key=\"$value\"";

                if (preg_match($pattern, $envContent)) {
                    $envContent = preg_replace($pattern, $replacement, $envContent);
                } else {
                    $envContent .= "\n$replacement";
                }
            }

            File::put($envPath, $envContent);
        }

        Artisan::call('config:clear');
    }
}
