<?php

namespace App\Http\Controllers;

use App\Models\StakingPlan;
use Illuminate\Http\Request;
use App\Models\Cryptocurrency;

class StakingPlanController extends Controller
{
    public function adminstakingindex(Request $request)
    {
        $stake = StakingPlan::with('crypto')->get();

        return view('admin.staking.index', compact('stake'));
    }

    public function adminstakingadd(Request $request)
    {
        $crypto = Cryptocurrency::where('status', '1')->get();

        return view('admin.staking.add', compact('crypto'));
    }

    public function adminstakingedit(Request $request, $id)
    {
        $crypto = Cryptocurrency::where('status', '1')->get();

        $stake = StakingPlan::findorfail($id);

        return view('admin.staking.edit', compact('stake', 'crypto'));
    }


    public function adminstakestore(Request $request)
    {
        $save = new StakingPlan;
        $save->cryptocurrency_id = $request->cryptocurrency_id;
        $save->name = $request->name;
        $save->interest_rate = $request->interest_rate;
        $save->duration = $request->duration;
        $save->minimum_amount = $request->minimum_amount;
        $save->maximum_amount = $request->maximum_amount;
        $save->status = $request->status;

        $save->save();

        return redirect()->route('admin.staking.index')->with('success', 'Stake Plan Added successfully');
    }


    public function adminstakeupdate(Request $request, $id)
    {
        $save = StakingPlan::findorfail($id);
        $save->cryptocurrency_id = $request->cryptocurrency_id;
        $save->name = $request->name;
        $save->interest_rate = $request->interest_rate;
        $save->duration = $request->duration;
        $save->minimum_amount = $request->minimum_amount;
        $save->maximum_amount = $request->maximum_amount;
        $save->status = $request->status;

        $save->save();

        return redirect()->route('admin.staking.index')->with('success', 'Stake Plan Updated successfully');
    }
}
