<?php

namespace App\Http\Controllers;

use App\Models\Instrument;
use App\Models\InvestmentPlan;
use Illuminate\Http\Request;

class HomeController extends Controller
{
    public function indexhome(Request $request)
    {
        $pageTitle = "Homepage";

        $invest = InvestmentPlan::all();

        return view('home', compact('invest', 'pageTitle'));
    }

    public function indexcrypto(Request $request)
    {
        $pageTitle = "CryptoCurrencies";

        return view('cryptocurrencies', compact('pageTitle'));
    }

    public function indexforex(Request $request)
    {
        $pageTitle = "Forex";
        return view('forex', compact('pageTitle'));
    }

    public function indexshares(Request $request)
    {
        $pageTitle = "Shares";
        return view('shares', compact('pageTitle'));
    }

    public function indexindices(Request $request)
    {
        $pageTitle = "Indices";
        return view('indices', compact('pageTitle'));
    }

    public function indexetfs(Request $request)
    {
        $pageTitle = "ETFS";
        return view('etfs', compact('pageTitle'));
    }

    public function indexautomate(Request $request)
    {
        $pageTitle = "Automate";
        return view('automate', compact('pageTitle'));
    }

    public function indexcopy(Request $request)
    {
        $pageTitle = "Copy";
        return view('copy', compact('pageTitle'));
    }

    public function indextrade(Request $request)
    {
        $pageTitle = "Trade";
        return view('trade', compact('pageTitle'));
    }

    public function indexterms(Request $request)
    {
        $pageTitle = "Terms";
        return view('terms', compact('pageTitle'));
    }

    public function indexprivacy(Request $request)
    {
        $pageTitle = "Privacy";
        return view('privacy', compact('pageTitle'));
    }

    public function indexlegals(Request $request)
    {
        $pageTitle = "Legals";
        return view('legals', compact('pageTitle'));
    }

    public function indexcontact(Request $request)
    {
        $pageTitle = "Contact";
        $captcha = $this->generateCaptcha(6);
        return view('contact', compact('pageTitle', 'captcha'));
    }

    protected function generateCaptcha(int $length = 6): string
    {
        $chars = 'ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789';
        $code = '';
        for ($i = 0; $i < $length; $i++) {
            $code .= $chars[random_int(0, strlen($chars) - 1)];
        }
        return $code;
    }

    public function indexeducation(Request $request)
    {
        $pageTitle = "Education";
        return view('for-traders', compact('pageTitle'));
    }

    public function indexabout(Request $request)
    {
        $pageTitle = "About";
        return view('about', compact('pageTitle'));
    }

    public function indexfaq(Request $request)
    {
        $pageTitle = "FAQ";
        return view('faq', compact('pageTitle'));
    }

    public function indexregulation(Request $request)
    {
        $pageTitle = "Regulation";
        return view('regulation', compact('pageTitle'));
    }

    public function indexwhy(Request $request)
    {
        $pageTitle = "Why Us";
        return view('why', compact('pageTitle'));
    }

    public function indextradingconditions(Request $request)
    {
        $pageTitle = "Trading Condition";
        return view('trading-conditions', compact('pageTitle'));
    }


    public function search(Request $request)
    {
        $query = $request->q;

        $results = Instrument::where('name', 'like', "%{$query}%")
            ->orWhere('symbol', 'like', "%{$query}%")
            ->limit(20)
            ->get(['id', 'name', 'symbol']);

        return response()->json($results);
    }
}
