<?php

namespace App\Http\Controllers;

use App\Http\Controllers\Controller;
use Illuminate\Support\Str;
use Illuminate\Support\Facades\Auth;
use App\Models\User;
use Socialite;

class GoogleController extends Controller
{
    public function redirect()
    {
        return Socialite::driver('google')->stateless()->redirect();
    }

    public function callback()
    {
        $googleUser = Socialite::driver('google')->stateless()->user();

        $user = User::where('email', $googleUser->getEmail())->first();

        if (!$user) {

            // Extract first name only (Google returns full name)
            $fullName = $googleUser->getName();
            $firstName = explode(' ', trim($fullName))[0];

            // Generate base username
            $baseUsername = strtolower(preg_replace('/[^a-zA-Z0-9]/', '', $firstName));

            // Generate a unique username: firstname + 3 numbers
            do {
                $username = $baseUsername . rand(100, 999);
            } while (User::where('username', $username)->exists());

            $user = User::create([
                'firstname' => $firstName,
                'lastname'  => '',
                'username'  => $username,   // 👈 NEW
                'status'  => 'active',
                'email'     => $googleUser->getEmail(),
                'password'  => bcrypt(Str::random(16)),
                'google_id' => $googleUser->getId(),
            ]);
        }

        $user->update([
            'last_login_at' => now(),
            'last_seen_at'  => now(),
        ]);

        Auth::login($user);

        return redirect()->route('user.dashboard');
    }
}
