<?php

namespace App\Http\Controllers;

use Illuminate\Support\Str;
use Illuminate\Http\Request;
use App\Models\Cryptocurrency;

class CryptoController extends Controller
{
    public function admincryptoindex(Request $request)
    {
        $crypto = Cryptocurrency::all();

        return view('admin.crypto.index', compact('crypto'));
    }


    public function admincryptoedit(Request $request, $id)
    {
        $crypto = Cryptocurrency::findorfail($id);

        return view('admin.crypto.edit', compact('crypto'));
    }

    public function admincryptoupdate(Request $request, $id)
    {
        $crypto = Cryptocurrency::findorfail($id);

        $crypto->name = $request->name;
        $crypto->full_name = $request->full_name;

        $filename = ['logo_icon'];

        foreach ($filename as $doc) {
            if ($request->hasFile($doc)) {
                $file = $request->file($doc);
                $name = Str::random(10) . '.' . $file->getClientOriginalExtension();

                $path = public_path('uploads/crypto');
                if (!file_exists($path)) {
                    mkdir($path, 0755, true);
                }

                $file->move($path, $name);

                $crypto[$doc] = 'uploads/crypto/' . $name;
            }
        }

        $crypto->save();

        return redirect()->route('admin.crypto.index')->with('success', 'Crypto updated successfully');
    }
}
