<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Http;

class AssetsController extends Controller
{
    // Return lists of assets (grouped by type)
    public function index()
    {
        // Fetch crypto list via CoinGecko
        $crypto = Http::get('https://api.coingecko.com/api/v3/coins/markets', [
            'vs_currency' => 'usd',
            'order' => 'market_cap_desc',
            'per_page' => 50,
            'page' => 1,
        ])->json();

        $apiKey = config('services.twelvedata.key');

        // Fetch forex list via Twelve Data
        $forex = Http::get('https://api.twelvedata.com/symbols', [
            'apikey' => $apiKey,
            'exchange' => 'FX',
        ])->json();

        // Fetch stocks list via Twelve Data
        $stocks = Http::get('https://api.twelvedata.com/symbols', [
            'apikey' => $apiKey,
            'exchange' => 'NYSE',
        ])->json();

        return view('assets.index', compact('crypto', 'forex', 'stocks'));
    }


    // Show details + chart for one asset
    public function show($asset)
    {
        // Example: fetch current data
        $data = Http::get('https://api.coingecko.com/api/v3/coins/' . $asset, [
            'localization' => false,
            'tickers' => false,
            'market_data' => true,
        ])->json();

        return view('assets.show', compact('data'));
    }
}
