<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;
use App\Models\User;

class AdminAuthController extends Controller
{
    public function adminLogin(Request $request)
    {
        $request->validate([
            'login'    => 'required|string|regex:/^[^<>]*$/',
            'password' => 'required|min:8|regex:/^[^<>]*$/',
        ]);

        // Email or username login
        $loginField = filter_var($request->login, FILTER_VALIDATE_EMAIL)
            ? 'email'
            : 'username';

        $user = User::where($loginField, $request->login)->first();

        // Validate user and password
        if (! $user || ! Hash::check($request->password, $user->password)) {
            return response()->json([
                'message' => 'Invalid credentials.',
            ], 401);
        }

        // Must be an admin
        if ($user->role !== 'admin') {
            return response()->json([
                'message' => 'Access denied. Admins only.',
            ], 403);
        }

        // Delete old tokens (optional)
        $user->tokens()->delete();

        // Create new sanctum token
        $token = $user->createToken('admin_app_token')->plainTextToken;

        return response()->json([
            'message' => 'Admin login successful.',
            'token'   => $token,
            'admin'   => $user,
        ]);
    }
}
