<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class AccessCodeController extends Controller
{
    public function access_code()
    {
        $pageTitle = 'Registration Access';

        return view('auth.access', compact('pageTitle'));
    }

    public function access_code_submit(Request $request)
    {
        // ✅ Validate that the code is provided and safe
        $request->validate([
            'access_code' => ['required', 'regex:/^[^<>]*$/'],
        ]);

        // ✅ Fetch the correct access code directly from the column
        $storedAccessCode = DB::table('website_settings')->value('access_code');

        // ✅ Compare the user’s input with the stored code
        if ($storedAccessCode && $request->access_code === $storedAccessCode) {
            // Store it in session so middleware recognizes it
            $request->session()->put('access_code', $request->access_code);

            // Redirect to register page with success
            return redirect()->route('register', ['access_code' => $request->access_code])
                ->with('success', 'Access code verified successfully. You can now register.');
        }

        // ❌ Invalid access code
        return back()->withErrors(['access_code' => 'Invalid access code.']);
    }
}
