<?php

use App\Models\UserActivityLog;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Request;

if (!function_exists('logUserActivity')) {
    /**
     * Log user activity with type, description, and meta info.
     *
     * @param string $activityType
     * @param string|null $description
     * @return void
     */
    function logUserActivity(string $activityType, ?string $description = null)
    {
        try {
            $user = Auth::user();

            if (!$user) {
                return; // skip for guests
            }

            UserActivityLog::create([
                'user_id' => $user->id,
                'activity_type' => $activityType,
                'description' => $description,
                'ip_address' => Request::ip(),
                'device' => Request::header('User-Agent'),
                'created_at' => now(),
            ]);
        } catch (\Throwable $e) {
            Log::error('Failed to log user activity: ' . $e->getMessage());
        }
    }
}
