<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use App\Models\ReferralLevel;
use App\Models\User;

class UpdateReferralLevels extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'app:update-referral-levels';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Command description';

    /**
     * Execute the console command.
     */
    public function handle()
    {
        $users = User::all();

        foreach ($users as $user) {
            $count = $user->referralsMade()->count();
            $level = ReferralLevel::where('min_referrals', '<=', $count)
                ->where(function ($q) use ($count) {
                    $q->where('max_referrals', '>=', $count)
                        ->orWhereNull('max_referrals');
                })
                ->first();

            if ($level && $user->referral_level_id != $level->id) {
                $user->update(['referral_level_id' => $level->id]);
            }
        }

        $this->info('Referral levels updated successfully!');
    }
}
