<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use App\Jobs\UpdateLiveTradesJob;

class UpdateLiveTradesCommand extends Command
{
    /**
     * The name and signature of the console command.
     *
     * Example usage: php artisan livetrades:update
     */
    protected $signature = 'livetrades:update';

    /**
     * The console command description.
     */
    protected $description = 'Update and close open live trades based on market data';

    /**
     * Execute the console command.
     */
    public function handle()
    {
        UpdateLiveTradesJob::dispatch();
        $this->info('✅ Live trades update job dispatched successfully.');
    }
}
